unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls;

type
  TfrmMain = class(TForm)
    bClose: TButton;
    lbUserInfo: TLabel;
    eUserInfo: TEdit;
    eHardware: TEdit;
    cbExpirationDate: TCheckBox;
    DateTimePicker1: TDateTimePicker;
    cbHardwareID: TCheckBox;
    gbSections: TGroupBox;
    cbSection1: TCheckBox;
    cbSection2: TCheckBox;
    cbSection3: TCheckBox;
    cbSection4: TCheckBox;
    cbSection5: TCheckBox;
    cbSection6: TCheckBox;
    cbSection7: TCheckBox;
    cbSection8: TCheckBox;
    cbSection9: TCheckBox;
    cbSection10: TCheckBox;
    cbSection11: TCheckBox;
    cbSection12: TCheckBox;
    cbSection13: TCheckBox;
    cbSection14: TCheckBox;
    cbSection15: TCheckBox;
    cbSection16: TCheckBox;
    bGen: TButton;
    bGenFP: TButton;
    mKey: TMemo;
    GroupBox1: TGroupBox;
    rbLongKey: TRadioButton;
    rbShortKey: TRadioButton;
    cbKeyType: TComboBox;
    btnVerify: TButton;
    btnVerifyP: TButton;
    procedure bCloseClick(Sender: TObject);
    procedure cbHardwareIDClick(Sender: TObject);
    procedure cbExpirationDateClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure bGenClick(Sender: TObject);
    procedure bGenFPClick(Sender: TObject);
    procedure btnVerifyClick(Sender: TObject);
    procedure btnVerifyPClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses enigma_keygen_ide;

{$R *.dfm}

procedure TfrmMain.bCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmMain.cbHardwareIDClick(Sender: TObject);
begin
  eHardware.Enabled := TCheckBox(Sender).Checked;
end;

procedure TfrmMain.cbExpirationDateClick(Sender: TObject);
begin
  DateTimePicker1.Enabled := TCheckBox(Sender).Checked;
end;

procedure TfrmMain.FormShow(Sender: TObject);
begin
  cbHardwareID.OnClick(cbHardwareID);
  cbExpirationDate.OnClick(cbExpirationDate);
end;

procedure TfrmMain.bGenClick(Sender: TObject);
var
  KeyParams : TGenKeyParams;
  KeyBuffer : array [0..255] of char;
  wYear, wMonth, wDay : word;
  dwResult : dword;
begin
  mKey.Clear;

  ZeroMemory(@KeyParams, SizeOf(KeyParams));
  // Key type
  if rbLongKey.Checked then KeyParams.KeyType := KEY_TYPE_LONG;
  if rbShortKey.Checked then KeyParams.KeyType := KEY_TYPE_SHORT;
  // Key format
  KeyParams.KeyFormat := KEY_FORMAT_32;
  case cbKeyType.ItemIndex of
    0: KeyParams.KeyFormat := KEY_FORMAT_10;
    1: KeyParams.KeyFormat := KEY_FORMAT_16;
    2: KeyParams.KeyFormat := KEY_FORMAT_32;
    3: KeyParams.KeyFormat := KEY_FORMAT_64;
  end;
  // Fill key buffer
  ZeroMemory(@KeyBuffer, SizeOf(KeyBuffer));
  KeyParams.Key := @KeyBuffer;
  KeyParams.KeyLen := SizeOf(KeyBuffer);
  // Fill User Info
  KeyParams.RegInfo := PChar(eUserInfo.Text);
  KeyParams.RegInfoLen := StrLen(KeyParams.RegInfo);
  // Key expiration info
  KeyParams.UseKeyExpiration := Byte(cbExpirationDate.Checked);
  DecodeDate(DateTimePicker1.DateTime, wYear, wMonth, wDay);
  KeyParams.ExpirationYear := wYear;
  KeyParams.ExpirationMonth := wMonth;
  KeyParams.ExpirationDay := wDay;
  // Hardware ID
  KeyParams.UseHardwareLocking := Byte(cbHardwareID.Checked);
  KeyParams.HardwareID := PChar(eHardware.Text);
  // Crypt Sections
  KeyParams.EncryptedSections[1] := Byte(cbSection1.Checked);
  KeyParams.EncryptedSections[2] := Byte(cbSection2.Checked);
  KeyParams.EncryptedSections[3] := Byte(cbSection3.Checked);
  KeyParams.EncryptedSections[4] := Byte(cbSection4.Checked);
  KeyParams.EncryptedSections[5] := Byte(cbSection5.Checked);
  KeyParams.EncryptedSections[6] := Byte(cbSection6.Checked);
  KeyParams.EncryptedSections[7] := Byte(cbSection7.Checked);
  KeyParams.EncryptedSections[8] := Byte(cbSection8.Checked);
  KeyParams.EncryptedSections[9] := Byte(cbSection9.Checked);
  KeyParams.EncryptedSections[10] := Byte(cbSection10.Checked);
  KeyParams.EncryptedSections[11] := Byte(cbSection11.Checked);
  KeyParams.EncryptedSections[12] := Byte(cbSection12.Checked);
  KeyParams.EncryptedSections[13] := Byte(cbSection13.Checked);
  KeyParams.EncryptedSections[14] := Byte(cbSection14.Checked);
  KeyParams.EncryptedSections[15] := Byte(cbSection15.Checked);
  KeyParams.EncryptedSections[16] := Byte(cbSection16.Checked);

  // Secure constant (get it from project file)!
  // or use special utility
  if KeyParams.KeyType = KEY_TYPE_LONG then
  begin
    KeyParams.D := '3K4RHBXV93J75R72XBF68M5GTQ2PDDVCJCQ9ZZ7CXBZYJNY6ASWVB6S3X4JP9TWPBANMW2HSMPAZ7GY5WZF8TQYJ36VUQZQ7J4F6JF';
    KeyParams.N := '7MSYMACUVPSKBB44WSEF3Q7T6ATNEDQ9D3UGQRP8SYVCXDDEX8TB78PFHWXGR4RVVTWVCSXANQWHDLWF2XTMS7PAA3396RALRP3UUK';
  end;
  if KeyParams.KeyType = KEY_TYPE_SHORT then
  begin
    KeyParams.D := '5V8YRKNAXCEPB46WAV4RPT95D6WMPHPKFJBXHDVDM';
    KeyParams.N := 'CNC74RPSW3DKWRSGRLDZS3D9G6XRYJ98QWHYX86AT';
  end;
  KeyParams.A := 'F4A190D21E05F4DF387A18CFBB70426E';
  KeyParams.B := 'C7A44A94C94D7F290037E9DACCC2CB23';
  // Generate reg. key
  dwResult := KG_GenerateRegistrationKey(@KeyParams);
  if dwResult = ERROR_OK then
  begin
    mKey.Text := String(KeyParams.Key);
  end else
  begin
    case dwResult of
      ERROR_KEY_BUFFER_NOT_ALLOCATED      : mKey.Text := 'ERROR_KEY_BUFFER_NOT_ALLOCATED'     ;
      ERROR_KEY_BUFFER_LESS               : mKey.Text := 'ERROR_KEY_BUFFER_LESS'              ;
      ERROR_REGINFO_BUFFER_NOT_ALLOCATED  : mKey.Text := 'ERROR_REGINFO_BUFFER_NOT_ALLOCATED' ;
      ERROR_REGINFO_BUFFER_EMPTY          : mKey.Text := 'ERROR_REGINFO_BUFFER_EMPTY'         ;
      ERROR_HARDWARE_TYPE_UNKNOWN         : mKey.Text := 'ERROR_HARDWARE_TYPE_UNKNOWN'        ;
      ERROR_HARDWARE_ID                   : mKey.Text := 'ERROR_HARDWARE_ID'                  ;
      ERROR_HARDWARE_BUFFER_NOT_ALLOCATED : mKey.Text := 'ERROR_HARDWARE_BUFFER_NOT_ALLOCATED';
      ERROR_HARDWARE_BUFFER_EMPTY         : mKey.Text := 'ERROR_HARDWARE_BUFFER_EMPTY'        ;
      ERROR_INVALID_CONSTANT_D            : mKey.Text := 'ERROR_INVALID_CONSTANT_D'           ;
      ERROR_INVALID_CONSTANT_N            : mKey.Text := 'ERROR_INVALID_CONSTANT_N'           ;
      ERROR_INVALID_CONSTANT_A            : mKey.Text := 'ERROR_INVALID_CONSTANT_A'           ;
      ERROR_INVALID_CONSTANT_B            : mKey.Text := 'ERROR_INVALID_CONSTANT_B'           ;
      ERROR_PROJECT_FILE_NOT_FOUND        : mKey.Text := 'ERROR_PROJECT_FILE_NOT_FOUND'       ;
      ERROR_PROJECT_FILE_INVALID          : mKey.Text := 'ERROR_PROJECT_FILE_INVALID'         ;
      else mKey.Text := 'ERROR_UNKNOWN';
    end;
  end;
end;

procedure TfrmMain.bGenFPClick(Sender: TObject);
var
  KeyParams : TGenKeyParams;
  KeyBuffer : array [0..255] of char;
  wYear, wMonth, wDay : word;
  dwResult : dword;
begin
  mKey.Clear;

  ZeroMemory(@KeyParams, SizeOf(KeyParams));
  // Fill key buffer
  ZeroMemory(@KeyBuffer, SizeOf(KeyBuffer));
  KeyParams.Key := @KeyBuffer;
  KeyParams.KeyLen := SizeOf(KeyBuffer);
  // Fill User Info
  KeyParams.RegInfo := PChar(eUserInfo.Text);
  KeyParams.RegInfoLen := StrLen(KeyParams.RegInfo);
  // Key expiration info
  KeyParams.UseKeyExpiration := Byte(cbExpirationDate.Checked);
  DecodeDate(DateTimePicker1.DateTime, wYear, wMonth, wDay);
  KeyParams.ExpirationYear := wYear;
  KeyParams.ExpirationMonth := wMonth;
  KeyParams.ExpirationDay := wDay;
  // Hardware ID
  KeyParams.UseHardwareLocking := Byte(cbHardwareID.Checked);
  KeyParams.HardwareID := PChar(eHardware.Text);
  // Crypt Sections
  KeyParams.EncryptedSections[1] := Byte(cbSection1.Checked);
  KeyParams.EncryptedSections[2] := Byte(cbSection2.Checked);
  KeyParams.EncryptedSections[3] := Byte(cbSection3.Checked);
  KeyParams.EncryptedSections[4] := Byte(cbSection4.Checked);
  KeyParams.EncryptedSections[5] := Byte(cbSection5.Checked);
  KeyParams.EncryptedSections[6] := Byte(cbSection6.Checked);
  KeyParams.EncryptedSections[7] := Byte(cbSection7.Checked);
  KeyParams.EncryptedSections[8] := Byte(cbSection8.Checked);
  KeyParams.EncryptedSections[9] := Byte(cbSection9.Checked);
  KeyParams.EncryptedSections[10] := Byte(cbSection10.Checked);
  KeyParams.EncryptedSections[11] := Byte(cbSection11.Checked);
  KeyParams.EncryptedSections[12] := Byte(cbSection12.Checked);
  KeyParams.EncryptedSections[13] := Byte(cbSection13.Checked);
  KeyParams.EncryptedSections[14] := Byte(cbSection14.Checked);
  KeyParams.EncryptedSections[15] := Byte(cbSection15.Checked);
  KeyParams.EncryptedSections[16] := Byte(cbSection16.Checked);
  // Generate reg. key
  dwResult := KG_GenerateRegistrationKeyFromProject(PChar(IncludeTrailingPathDelimiter(ExtractFilePath(Application.ExeName)) + 'default.enigma'), @KeyParams);
  if dwResult = ERROR_OK then
  begin
    mKey.Text := String(KeyParams.Key);
  end else
  begin
    case dwResult of
      ERROR_KEY_BUFFER_NOT_ALLOCATED      : mKey.Text := 'ERROR_KEY_BUFFER_NOT_ALLOCATED'     ;
      ERROR_KEY_BUFFER_LESS               : mKey.Text := 'ERROR_KEY_BUFFER_LESS'              ;
      ERROR_REGINFO_BUFFER_NOT_ALLOCATED  : mKey.Text := 'ERROR_REGINFO_BUFFER_NOT_ALLOCATED' ;
      ERROR_REGINFO_BUFFER_EMPTY          : mKey.Text := 'ERROR_REGINFO_BUFFER_EMPTY'         ;
      ERROR_HARDWARE_TYPE_UNKNOWN         : mKey.Text := 'ERROR_HARDWARE_TYPE_UNKNOWN'        ;
      ERROR_HARDWARE_ID                   : mKey.Text := 'ERROR_HARDWARE_ID'                  ;
      ERROR_HARDWARE_BUFFER_NOT_ALLOCATED : mKey.Text := 'ERROR_HARDWARE_BUFFER_NOT_ALLOCATED';
      ERROR_HARDWARE_BUFFER_EMPTY         : mKey.Text := 'ERROR_HARDWARE_BUFFER_EMPTY'        ;
      ERROR_INVALID_CONSTANT_D            : mKey.Text := 'ERROR_INVALID_CONSTANT_D'           ;
      ERROR_INVALID_CONSTANT_N            : mKey.Text := 'ERROR_INVALID_CONSTANT_N'           ;
      ERROR_INVALID_CONSTANT_A            : mKey.Text := 'ERROR_INVALID_CONSTANT_A'           ;
      ERROR_INVALID_CONSTANT_B            : mKey.Text := 'ERROR_INVALID_CONSTANT_B'           ;
      ERROR_PROJECT_FILE_NOT_FOUND        : mKey.Text := 'ERROR_PROJECT_FILE_NOT_FOUND'       ;
      ERROR_PROJECT_FILE_INVALID          : mKey.Text := 'ERROR_PROJECT_FILE_INVALID'         ;
      else mKey.Text := 'ERROR_UNKNOWN';
    end;
  end;
end;

procedure TfrmMain.btnVerifyClick(Sender: TObject);
var
  VerifyKey : TVerifyKey;
  dwResult, i : dword;
  sOutputResult : string;
begin
  if eUserInfo.Text = '' then
  begin
    ShowMessage('User info field is empty!');
    Exit;
  end;
  if mKey.Text = '' then
  begin
    ShowMessage('Key field is empty!');
    Exit;
  end;

  VerifyKey.Key := PChar(mKey.Text);
  // Key type
  if rbLongKey.Checked then VerifyKey.KeyType := KEY_TYPE_LONG;
  if rbShortKey.Checked then VerifyKey.KeyType := KEY_TYPE_SHORT;
  // Key format
  VerifyKey.KeyFormat := KEY_FORMAT_32;
  case cbKeyType.ItemIndex of
    0: VerifyKey.KeyFormat := KEY_FORMAT_10;
    1: VerifyKey.KeyFormat := KEY_FORMAT_16;
    2: VerifyKey.KeyFormat := KEY_FORMAT_32;
    3: VerifyKey.KeyFormat := KEY_FORMAT_64;
  end;
  VerifyKey.RegInfo := PChar(eUserInfo.Text);

  // Secure constant (get it from project file)!
  // or use special utility
  if VerifyKey.KeyType = KEY_TYPE_LONG then
  begin
    VerifyKey.E := '35AL5XHXFAJZUKEUZVFHSQ2Q3BNECXCAFTEPXQ9S8KWNF89XPYNZCXCAUEEXYVGQJAN5MTZ58BUX6MG5FFP2NUX7QXCF2XK5T344GHF';
    VerifyKey.N := '7MSYMACUVPSKBB44WSEF3Q7T6ATNEDQ9D3UGQRP8SYVCXDDEX8TB78PFHWXGR4RVVTWVCSXANQWHDLWF2XTMS7PAA3396RALRP3UUK';
  end;
  if VerifyKey.KeyType = KEY_TYPE_SHORT then
  begin
    VerifyKey.E := '3WMT5MUA2J3VG4BE3P3B3T9C74YGC7JEZYF2N323SD';
    VerifyKey.N := 'CNC74RPSW3DKWRSGRLDZS3D9G6XRYJ98QWHYX86AT';
  end;
  VerifyKey.A := 'F4A190D21E05F4DF387A18CFBB70426E';
  VerifyKey.B := 'C7A44A94C94D7F290037E9DACCC2CB23';

  dwResult := KG_VerifyRegistrationInfo(@VerifyKey);

  case dwResult of
    ERROR_UNKNOWN                       : sOutputResult := 'ERROR_UNKNOWN                      ';
    ERROR_OK                            :
    begin
      sOutputResult := 'Valid Regsitartion Information'#10#13;
      sOutputResult := sOutputResult + format('Key creation date: %d, %d, %d'#10#13,
                              [VerifyKey.CreateDay, VerifyKey.CreateMonth, VerifyKey.CreateYear]);
      if VerifyKey.UseKeyExpiration = 1 then
        sOutputResult := sOutputResult + format('Key expiration date: %d, %d, %d'#10#13,
                                [VerifyKey.ExpirationDay, VerifyKey.ExpirationMonth, VerifyKey.ExpirationYear]);
      if VerifyKey.UseHardwareLocking = 1 then
      begin
        sOutputResult := sOutputResult + 'Hardware Type: ';
        if (VerifyKey.HardwareIDType and HID_HARDDISK)        <> 0 then
          sOutputResult := sOutputResult + 'HID_HARDDISK ';
        if (VerifyKey.HardwareIDType and HID_VOLUMENAME)      <> 0 then
          sOutputResult := sOutputResult + 'HID_VOLUMENAME ';
        if (VerifyKey.HardwareIDType and HID_CPUTYPE)         <> 0 then
          sOutputResult := sOutputResult + 'HID_CPUTYPE ';
        if (VerifyKey.HardwareIDType and HID_COMPUTERNAME)    <> 0 then
          sOutputResult := sOutputResult + 'HID_COMPUTERNAME ';
        if (VerifyKey.HardwareIDType and HID_MOTHERBOARDBIOS) <> 0 then
          sOutputResult := sOutputResult + 'HID_MOTHERBOARDBIOS ';
        sOutputResult := sOutputResult + #10#13;
        sOutputResult := sOutputResult + string(VerifyKey.HardwareID) + #10#13;
      end;
      for i := 1 to NUMBER_OF_CRYPTED_SECTIONS do
      begin
        if VerifyKey.EncryptedSections[i] = 1 then
          sOutputResult := sOutputResult + format('Section #%d is unlocked', [i]) + #10#13;
      end;
    end;
    ERROR_KEY_BUFFER_NOT_ALLOCATED      : sOutputResult := 'ERROR_KEY_BUFFER_NOT_ALLOCATED     ';
    ERROR_KEY_BUFFER_LESS               : sOutputResult := 'ERROR_KEY_BUFFER_LESS              ';
    ERROR_REGINFO_BUFFER_NOT_ALLOCATED  : sOutputResult := 'ERROR_REGINFO_BUFFER_NOT_ALLOCATED ';
    ERROR_REGINFO_BUFFER_EMPTY          : sOutputResult := 'ERROR_REGINFO_BUFFER_EMPTY         ';
    ERROR_HARDWARE_TYPE_UNKNOWN         : sOutputResult := 'ERROR_HARDWARE_TYPE_UNKNOWN        ';
    ERROR_HARDWARE_ID                   : sOutputResult := 'ERROR_HARDWARE_ID                  ';
    ERROR_HARDWARE_BUFFER_NOT_ALLOCATED : sOutputResult := 'ERROR_HARDWARE_BUFFER_NOT_ALLOCATED';
    ERROR_HARDWARE_BUFFER_EMPTY         : sOutputResult := 'ERROR_HARDWARE_BUFFER_EMPTY        ';
    ERROR_INVALID_CONSTANT_D            : sOutputResult := 'ERROR_INVALID_CONSTANT_D           ';
    ERROR_INVALID_CONSTANT_N            : sOutputResult := 'ERROR_INVALID_CONSTANT_N           ';
    ERROR_INVALID_CONSTANT_A            : sOutputResult := 'ERROR_INVALID_CONSTANT_A           ';
    ERROR_INVALID_CONSTANT_B            : sOutputResult := 'ERROR_INVALID_CONSTANT_B           ';
    ERROR_PROJECT_FILE_NOT_FOUND        : sOutputResult := 'ERROR_PROJECT_FILE_NOT_FOUND       ';
    ERROR_PROJECT_FILE_INVALID          : sOutputResult := 'ERROR_PROJECT_FILE_INVALID         ';
    ERROR_INVALID_CONSTANT_E            : sOutputResult := 'ERROR_INVALID_CONSTANT_E           ';
    ERROR_INVALID_KEYTYPE               : sOutputResult := 'ERROR_INVALID_KEYTYPE              ';
    ERROR_INVALID_REGINFO               : sOutputResult := 'ERROR_INVALID_REGINFO              ';
  end;
  ShowMessage(sOutputResult);
end;

procedure TfrmMain.btnVerifyPClick(Sender: TObject);
var
  VerifyKey : TVerifyKey;
  dwResult, i : dword;
  sOutputResult : string;
begin
  if eUserInfo.Text = '' then
  begin
    ShowMessage('User info field is empty!');
    Exit;
  end;
  if mKey.Text = '' then
  begin
    ShowMessage('Key field is empty!');
    Exit;
  end;

  VerifyKey.RegInfo := PChar(eUserInfo.Text);
  VerifyKey.Key := PChar(mKey.Text);

  dwResult := KG_VerifyRegistrationInfoFromProject(PChar(IncludeTrailingPathDelimiter(ExtractFilePath(Application.ExeName)) + 'default.enigma'), @VerifyKey);

  case dwResult of
    ERROR_UNKNOWN                       : sOutputResult := 'ERROR_UNKNOWN                      ';
    ERROR_OK                            :
    begin
      sOutputResult := 'Valid Regsitartion Information'#10#13;
      sOutputResult := sOutputResult + format('Key creation date: %d, %d, %d'#10#13,
                              [VerifyKey.CreateDay, VerifyKey.CreateMonth, VerifyKey.CreateYear]);
      if VerifyKey.UseKeyExpiration = 1 then
        sOutputResult := sOutputResult + format('Key expiration date: %d, %d, %d'#10#13,
                                [VerifyKey.ExpirationDay, VerifyKey.ExpirationMonth, VerifyKey.ExpirationYear]);
      if VerifyKey.UseHardwareLocking = 1 then
      begin
        sOutputResult := sOutputResult + 'Hardware Type: ';
        if (VerifyKey.HardwareIDType and HID_HARDDISK)        <> 0 then
          sOutputResult := sOutputResult + 'HID_HARDDISK ';
        if (VerifyKey.HardwareIDType and HID_VOLUMENAME)      <> 0 then
          sOutputResult := sOutputResult + 'HID_VOLUMENAME ';
        if (VerifyKey.HardwareIDType and HID_CPUTYPE)         <> 0 then
          sOutputResult := sOutputResult + 'HID_CPUTYPE ';
        if (VerifyKey.HardwareIDType and HID_COMPUTERNAME)    <> 0 then
          sOutputResult := sOutputResult + 'HID_COMPUTERNAME ';
        if (VerifyKey.HardwareIDType and HID_MOTHERBOARDBIOS) <> 0 then
          sOutputResult := sOutputResult + 'HID_MOTHERBOARDBIOS ';
        sOutputResult := sOutputResult + #10#13;
        sOutputResult := sOutputResult + string(VerifyKey.HardwareID) + #10#13;
      end;
      for i := 1 to NUMBER_OF_CRYPTED_SECTIONS do
      begin
        if VerifyKey.EncryptedSections[i] = 1 then
          sOutputResult := sOutputResult + format('Section #%d is unlocked', [i]) + #10#13;
      end;
    end;
    ERROR_KEY_BUFFER_NOT_ALLOCATED      : sOutputResult := 'ERROR_KEY_BUFFER_NOT_ALLOCATED     ';
    ERROR_KEY_BUFFER_LESS               : sOutputResult := 'ERROR_KEY_BUFFER_LESS              ';
    ERROR_REGINFO_BUFFER_NOT_ALLOCATED  : sOutputResult := 'ERROR_REGINFO_BUFFER_NOT_ALLOCATED ';
    ERROR_REGINFO_BUFFER_EMPTY          : sOutputResult := 'ERROR_REGINFO_BUFFER_EMPTY         ';
    ERROR_HARDWARE_TYPE_UNKNOWN         : sOutputResult := 'ERROR_HARDWARE_TYPE_UNKNOWN        ';
    ERROR_HARDWARE_ID                   : sOutputResult := 'ERROR_HARDWARE_ID                  ';
    ERROR_HARDWARE_BUFFER_NOT_ALLOCATED : sOutputResult := 'ERROR_HARDWARE_BUFFER_NOT_ALLOCATED';
    ERROR_HARDWARE_BUFFER_EMPTY         : sOutputResult := 'ERROR_HARDWARE_BUFFER_EMPTY        ';
    ERROR_INVALID_CONSTANT_D            : sOutputResult := 'ERROR_INVALID_CONSTANT_D           ';
    ERROR_INVALID_CONSTANT_N            : sOutputResult := 'ERROR_INVALID_CONSTANT_N           ';
    ERROR_INVALID_CONSTANT_A            : sOutputResult := 'ERROR_INVALID_CONSTANT_A           ';
    ERROR_INVALID_CONSTANT_B            : sOutputResult := 'ERROR_INVALID_CONSTANT_B           ';
    ERROR_PROJECT_FILE_NOT_FOUND        : sOutputResult := 'ERROR_PROJECT_FILE_NOT_FOUND       ';
    ERROR_PROJECT_FILE_INVALID          : sOutputResult := 'ERROR_PROJECT_FILE_INVALID         ';
    ERROR_INVALID_CONSTANT_E            : sOutputResult := 'ERROR_INVALID_CONSTANT_E           ';
    ERROR_INVALID_KEYTYPE               : sOutputResult := 'ERROR_INVALID_KEYTYPE              ';
    ERROR_INVALID_REGINFO               : sOutputResult := 'ERROR_INVALID_REGINFO              ';
  end;
  ShowMessage(sOutputResult);
end;

end.
